var filename_part1 = 'erb';
var filename_part2 = '12';

var categories = {
'sd-100': 'Fuse & Relay Information',
'sd-130': 'Ground Distribution',
'sd-120': 'Passenger Compartment Fuse Details',
'sd-110': 'Power Distribution',
'sd-971': 'AC Control System',
'sd-587': 'Anti-lock Brake System (ABS)',
'sd-961': 'Audio System',
'sd-450': 'Automatic Transaxle Control System',
'sd-926': 'Back-Up Lamps',
'sd-952': 'Body Control Module (BCM) System',
'sd-373': 'Charging System',
'sd-945': 'Clock & Cigarette Lighter (Power Outlet) System',
'sd-253': 'Cooling System',
'sd-929': 'Courtesy & Trunk Lamps',
'sd-200': 'Data Link Details',
'sd-958': 'Daytime Running Lights (DRL)',
'sd-879': 'Defogger System',
'sd-588': 'Electronic Stability Control (ESC) System',
'sd-924': 'Fog Lamps',
'sd-921': 'Head Lamps',
'sd-968': 'Horn',
'sd-941': 'Illuminations',
'sd-954': 'Immobilizer Control',
'sd-940': 'Indicators & Gauges',
'sd-313': 'MFI Control System',
'sd-813': 'Power Door Locks',
'sd-876': 'Power Outside Mirror System',
'sd-563': 'Power Steering System',
'sd-824': 'Power Window System',
'sd-889': 'Seat Warmer System',
'sd-360': 'Starting System',
'sd-927': 'Stop Lamps',
'sd-816': 'Sunroof System',
'sd-569': 'Supplemental Restraint System (SRS)',
'sd-928': 'Tail, Parking & License Lamps',
'sd-956': 'Tire Pressure Monitoring System (TPMS)',
'sd-925': 'Turn & Hazard Lamps',
'sd-436': 'Vehicle Speed System',
'sd-981': 'Wiper & Washer System',
'st-587': 'Anti-lock Brack System (ABS)',
'st-373': 'Charging System',
'st-253': 'Cooling System',
'st-588': 'Electronic Stability (ESC) System',
'st-921': 'Head Lamps',
'st-941': 'Illuminations',
'st-954': 'Immobilizer Control',
'st-313': 'MFI Control System',
'st-813': 'Power Door Locks',
'st-876': 'Power Outside Mirrors',
'st-360': 'Starting System',
'st-927': 'Stop Lamps',
'st-816': 'Sunroof System',
'st-925': 'Turn & Hazard Lamps',
'st-436': 'Vehicle Speed System',
'st-981': 'Wiper & Washer System'};


function ref(ref_value) {

// Pass the category text to the popup so we have a meaningful window title.
var type_param   = gup('type');

var url = '../../html/diagram.html?type=' + type_param + '&filename=' + ref_value;

var winobj;
winobj = window.open(url, '_blank','left=0, top=0, toolbar=no, location=no, directories=no, status=no, menubar=no, scrollbars=yes, resizable=yes, width=735, height=541');
winobj.focus();

}


function part(part_value){

var url = '../../html/part popup.html?part=' + part_value;

var winobj;
winobj = window.open(url, '_blank','left=0, top=0, toolbar=no, location=no, directories=no, status=no, menubar=no, scrollbars=yes, resizable=yes, width=490, height=490');
winobj.focus();

}

function zoomin() {
alert("click");
}

// Returns URL param value
function gup( name ){
name = name.replace(/[\[]/,"\\\[").replace(/[\]]/,"\\\]");
var regexS = "[\\?&]"+name+"=([^&#]*)";
var regex = new RegExp( regexS );
var results = regex.exec( window.location.href );
 if( results == null )    return null;
 else    return results[1];
}


// Sets HTML when page loads.
function generatePage() {

var path_base       = '../Hyundai files/';
var path_schematics = 'Schematic diagrams/'
var path_tips       = 'Service tips/'

var type_param     = gup('type');
var name_param     = gup('name');
var filename_param = gup('filename');

var old_object, new_object;

// Popup requested.
if (filename_param !== null) {

  document.getElementById('related').setAttribute('class', 'no-disp');

// This is a hack for Google Chrome (and perhaps Safari). Chrome doesn't reload
// the object when the 'data' attribute is changed. We have to clone the object,
// change the 'data' element, then replace the original object with the new one.
old_object = document.getElementById('svg1');
new_object = old_object.cloneNode(true);
new_object.setAttribute('data', path_base + path_schematics + filename_param + '.svg');
old_object.parentNode.replaceChild(new_object, old_object);

  // Doesn't work with Google Chrome (and perhaps Safari)
  // document.getElementById('svg1').data = path_base + path_schematics + filename_param + '.svg';

  // Set the diagram number for the window title. Convert the 2nd to last
  // letter to a number. Subtract 96. ("a" is ASCII 97.).
  var str_len = filename_param.length;
  var str_enum = filename_param.substr(str_len - 2, 1);
  str_enum = str_enum.charCodeAt(0);

  var name_from_filename = filename_param.substr(7, 3)

  document.title = categories[type_param + '-' + name_from_filename] + ' #' + (str_enum - 96);

  return;
}

var tot_param   = gup('tot');
var num_param   = gup('num');
var start_param = gup('start');

var related_html;
var related_links;
var ascii_code;
var svg_filename;

// Setup the path for the resource type.
if      (type_param == 'sd') path_base = path_base + path_schematics;
else if (type_param == 'st') path_base = path_base + path_tips;


// The following initialization affects the "related schematics" for a category.
// I.e., the 1-n links above a schematic. When this URI is called from the
// index page (to display the first page) we don't provide the "num" nor "start"
// params. It keeps the URL clean(er) looking. When one of the related links is
// clicked, this URI is called with those params. I.e., the "num" to display,
// and where to start the enumeration. (Some categories have 1-16, for example,
// but 1-8 are for automatic transmission. 9-16 is for manual. So, in the latter
// case, we might display file 11, but start at 9 for a total of 8.
//
// Anyway, because "num" and "start" aren't provided from the index page, we need
// to initialize them to their implied values. If we're not "start"ing the
// enumeration at an unusual place, then a null "num" is implied to be "1." If
// we "start" enumeration somewhere else, "num" is implied to be the same as
// that "start" value.
if (num_param === null) {
    if (start_param === null) {
        start_param = 1;
        num_param = 1;
    }
    else {
        num_param = start_param;
    }
}
else if (start_param === null) {
    start_param = 1;
}

num_param   = parseInt(num_param);
start_param = parseInt(start_param);
tot_param   = parseInt(tot_param);

// alert("start, num and tot params: " + start_param + ", " + num_param + ", " + tot_param);

// The related links will always have a "Home" link back to the index page.
related_html = '<a class="button-link" href="../index.html">Home</a>';

// If there are more than one related page, generate the enumerated links.
if (tot_param > 1) {
    // alert('here ' + start_param + ' ' + tot_param);
    for (var i=start_param; i<=tot_param; i++) {
        // alert("In loop: " + i);
        if (i == num_param) { related_links = ' <span>' + i + '</span>' }
        else { related_links = ' <a class="button-link" href="diagram.html?type=' + type_param + '&name=' + name_param + '&tot=' + tot_param + '&start=' + start_param + '&num=' + i + '">' + i + '</a>'; }

        related_html = related_html + ' ' + related_links;
    }
}

document.getElementById('related').innerHTML = related_html;

// This is a tricky way to convert a number to a letter. ASCII 97 is "a". 98 is "b".
ascii_code = String.fromCharCode(96 + num_param);

// alert("ascii: " + ascii_code);

svg_filename = path_base + filename_part1 + type_param + filename_part2 + name_param + ascii_code + 'n.svg';

// This is a hack for Google Chrome (and perhaps Safari). Chrome doesn't reload
// the object when the 'data' attribute is changed. We have to clone the object,
// change the 'data' element, then replace the original object with the new one.
old_object = document.getElementById('svg1');
new_object = old_object.cloneNode(true);
new_object.setAttribute('data', svg_filename);
old_object.parentNode.replaceChild(new_object, old_object);

// Doesn't work with Google Chrome (and perhaps Safari)
// document.getElementById('svg1').setAttribute('data', svg_filename);

// Set the page title
document.title = categories[type_param + '-' + name_param] + ' #' + num_param;

return;

}